/** @file   objectid.h
 * @brief   Definitions of object type ids.
 * @version $Revision: 1.9 $
 * @date    $Date: 2006/07/13 16:27:05 $
 * @author  Tomi Lamminsaari
 */

#ifndef H_WWW_OBJECTID_H
#define H_WWW_OBJECTID_H

namespace WeWantWar {


/** @class  ObjectID
 * @brief   This static class contains the ID-codes for different object types.
 * @author  Tomi Lamminsaari
 *
 * There is no need to create any instances of this class. This just
 * encapsulates the object type id constants.
 *
 * The GameObject::objectType() - method returns these constants. That
 * method must be implemented in child classes and they must return
 * corresponding constant.
 */
class ObjectID
{
public:

  /** Object Runtime type information */
  typedef int Type;
  

  ///
  /// Player
  /// ======
  
  /** ID for Player */
  static const Type TYPE_PLAYER = 0;
  
  
  ///
  /// Aliens
  /// ======
  
  /** ID for CarnivoreAlien */
  static const Type TYPE_CARNIVOREALIEN = 1;
  /** ID for SmallWormAlien */
  static const Type TYPE_SMALLWORMALIEN = 2;
  /** ID for WingedAlien */
  static const Type TYPE_WINGEDALIEN = 3;
  /** ID for ProctorAlien */
  static const Type TYPE_PROCTORALIEN = 4;
  /** ID for MinigunAlien */
  static const Type TYPE_MINIGUNALIEN = 5;
  /** ID for PredatorAlien */
  static const Type TYPE_PREDATORALIEN = 6;
  /** ID for MediumWormAlien */
  static const Type TYPE_MEDIUMWORMALIEN = 7;
  /** ID for FlamerAlien */
  static const Type TYPE_FLAMERALIEN = 8;
  /** ID for LightballAlien */
  static const Type TYPE_LIGHTBALLALIEN = 9;
  /** ID of the Guardian Tank */
  static const Type TYPE_GUARDIANTANK = 10;
  /** ID of the bad ass alien */
  static const Type TYPE_BADASSALIEN = 11;
  /** ID of the Hidden Flower alien */
  static const Type TYPE_HIDDENWORMALIEN = 12;
  /** ID of SlimeAlien */
  static const Type TYPE_SLIMEALIEN = 13;
  /** ID of HotSpot objects */
  static const Type TYPE_HOTSPOT = 14;
  /** ID of Music control object. */
  static const Type TYPE_MUSICCONTROLOBJECT = 15;
  /** ID of the ultimate baddass alien. */
  static const Type TYPE_ULTIMATEBADASSALIEN = 16;
  
  ///
  /// Personel
  /// ========
  
  /** ID for Civilian */
  static const Type TYPE_CIVILIAN = 32;
  /** ID for Corpse */
  static const Type TYPE_CORPSE = 33;
  /** ID of the Youko character. */
  static const Type TYPE_YOUKO = 34;
  /** ID od Simon - character */
  static const Type TYPE_SIMON = 35;
  /** ID of Eric */
  static const Type TYPE_ERIC = 36;
  
  
  ///
  /// Other objects
  /// =============
  
  /** ID for GasLeak */
  static const Type TYPE_GASLEAK = 64;
  /** ID for SentryGun */
  static const Type TYPE_SENTRYGUN = 65;
  /** ID for Car */
  static const Type TYPE_CAR = 66;
  /** ID for Fighter plane */
  static const Type TYPE_FIGHTER = 67;
  /** ID of the tanks */
  static const Type TYPE_TANK = 68;
  /** ID of the Electric fence */
  static const Type TYPE_LIGHTFENCE = 100;
  /** ID of the Mines */
  static const Type TYPE_MINE = 200;
  /** ID of the Decorative Object */
  static const Type TYPE_DECORATIVEOBJECT = 201;
  /** ID of the Barrell object */
  static const Type TYPE_BARREL = 202;
  /** ID of the car the player uses. */
  static const Type TYPE_PLAYERCAR = 203;
  /** Id of the StarGate object */
  static const Type TYPE_STARGATE = 204;
  /** Id of the Machine gun the player can use. */
  static const Type TYPE_MACHINEGUN = 205;
};

};  // end of namespace

#endif // OBJECTID_H

/**
 * Version history
 * ===============
 * $Log: objectid.h,v $
 * Revision 1.9  2006/07/13 16:27:05  lamminsa
 * TYPE_ULTIMATEBADASS added.
 *
 * Revision 1.8  2006/05/15 19:21:11  lamminsa
 * Music control object added.
 *
 * Revision 1.7  2006/05/08 21:31:34  lamminsa
 * SlimeAlien added.
 *
 * Revision 1.6  2006/04/25 18:03:23  lamminsa
 * TYPE_HIDDENWORMALIEN added.
 *
 * Revision 1.5  2006/04/12 21:11:23  lamminsa
 * no message
 *
 * Revision 1.4  2006/03/29 22:27:01  lamminsa
 * no message
 *
 * Revision 1.3  2006/02/26 07:39:22  lamminsa
 * no message
 *
 * Revision 1.2  2006/02/17 23:09:07  lamminsa
 * no message
 *
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.2  2005-12-30 23:40:48+02  lamminsa
 * <>
 *
 * Revision 1.1  2005-11-23 00:21:59+02  lamminsa
 * Lightball alien added.
 *
 * Revision 1.0  2005-11-06 01:17:07+02  lamminsa
 * Initial revision
 *
 */
 
